package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserImportJobResponse(
    userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse = {
    import DescribeUserImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse
      .builder()
      .optionallyWith(userImportJob.map(value => value.buildAwsValue()))(
        _.userImportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse
      .wrap(buildAwsValue())
}
object DescribeUserImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse =
      zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse(
        userImportJob.map(value => value.asEditable)
      )
    def userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ]
    def getUserImportJob: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = AwsError.unwrapOptionField("userImportJob", userImportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly {
    override val userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = scala
      .Option(impl.userImportJob())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
