package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChallengeResponseType(
    challengeName: Option[zio.aws.cognitoidentityprovider.model.ChallengeName] =
      None,
    challengeResponse: Option[
      zio.aws.cognitoidentityprovider.model.ChallengeResponse
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType = {
    import ChallengeResponseType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
      .builder()
      .optionallyWith(challengeName.map(value => value.unwrap))(_.challengeName)
      .optionallyWith(challengeResponse.map(value => value.unwrap))(
        _.challengeResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ChallengeResponseType
      .wrap(buildAwsValue())
}
object ChallengeResponseType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ChallengeResponseType =
      zio.aws.cognitoidentityprovider.model.ChallengeResponseType(
        challengeName.map(value => value),
        challengeResponse.map(value => value)
      )
    def challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeName]
    def challengeResponse
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeResponse]
    def getChallengeName: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeName
    ] = AwsError.unwrapOptionField("challengeName", challengeName)
    def getChallengeResponse: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeResponse
    ] = AwsError.unwrapOptionField("challengeResponse", challengeResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ) extends zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly {
    override val challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeName] = scala
      .Option(impl.challengeName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.ChallengeName.wrap(value)
      )
    override val challengeResponse
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeResponse] =
      scala
        .Option(impl.challengeResponse())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType
  ): zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly =
    new Wrapper(impl)
}
