package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SessionType
}
import scala.jdk.CollectionConverters._
final case class InitiateAuthResponse(
    challengeName: Option[
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = None,
    session: Option[SessionType] = None,
    challengeParameters: Option[Map[StringType, StringType]] = None,
    authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse = {
    import InitiateAuthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse
      .builder()
      .optionallyWith(challengeName.map(value => value.unwrap))(_.challengeName)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .optionallyWith(
        challengeParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.challengeParameters)
      .optionallyWith(authenticationResult.map(value => value.buildAwsValue()))(
        _.authenticationResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.InitiateAuthResponse
      .wrap(buildAwsValue())
}
object InitiateAuthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.InitiateAuthResponse =
      zio.aws.cognitoidentityprovider.model.InitiateAuthResponse(
        challengeName.map(value => value),
        session.map(value => value),
        challengeParameters.map(value => value),
        authenticationResult.map(value => value.asEditable)
      )
    def challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeNameType]
    def session: Option[SessionType]
    def challengeParameters: Option[Map[StringType, StringType]]
    def authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ]
    def getChallengeName: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = AwsError.unwrapOptionField("challengeName", challengeName)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getChallengeParameters
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("challengeParameters", challengeParameters)
    def getAuthenticationResult: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationResult", authenticationResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse
  ) extends zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly {
    override val challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeNameType] =
      scala
        .Option(impl.challengeName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeNameType.wrap(value)
        )
    override val session: Option[SessionType] = scala
      .Option(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val challengeParameters: Option[Map[StringType, StringType]] =
      scala
        .Option(impl.challengeParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = scala
      .Option(impl.authenticationResult())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AuthenticationResultType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse
  ): zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly =
    new Wrapper(impl)
}
