package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  TokenModelType,
  DeviceKeyType
}
import scala.jdk.CollectionConverters._
final case class GetDeviceRequest(
    deviceKey: DeviceKeyType,
    accessToken: Option[TokenModelType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest = {
    import GetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest
      .builder()
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetDeviceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetDeviceRequest.wrap(buildAwsValue())
}
object GetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetDeviceRequest =
      zio.aws.cognitoidentityprovider.model
        .GetDeviceRequest(deviceKey, accessToken.map(value => value))
    def deviceKey: DeviceKeyType
    def accessToken: Option[TokenModelType]
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetDeviceRequest.ReadOnly {
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
    override val accessToken: Option[TokenModelType] = scala
      .Option(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest
  ): zio.aws.cognitoidentityprovider.model.GetDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
