package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKey,
  QueryLimitType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminListUserAuthEventsRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    maxResults: Option[QueryLimitType] = None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest = {
    import AdminListUserAuthEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        maxResults.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
      .wrap(buildAwsValue())
}
object AdminListUserAuthEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest =
      zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest(
        userPoolId,
        username,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def maxResults: Option[QueryLimitType]
    def nextToken: Option[PaginationKey]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getMaxResults: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val maxResults: Option[QueryLimitType] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
  ): zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsRequest.ReadOnly =
    new Wrapper(impl)
}
