package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  CSSType,
  DateType,
  UserPoolIdType,
  CSSVersionType,
  ClientIdType,
  ImageUrlType
}
import scala.jdk.CollectionConverters._
final case class UICustomizationType(
    userPoolId: Option[UserPoolIdType] = None,
    clientId: Option[ClientIdType] = None,
    imageUrl: Option[ImageUrlType] = None,
    css: Option[CSSType] = None,
    cssVersion: Option[CSSVersionType] = None,
    lastModifiedDate: Option[DateType] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType = {
    import UICustomizationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        imageUrl.map(value => ImageUrlType.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(
        css.map(value => CSSType.unwrap(value): java.lang.String)
      )(_.css)
      .optionallyWith(
        cssVersion.map(value => CSSVersionType.unwrap(value): java.lang.String)
      )(_.cssVersion)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UICustomizationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UICustomizationType
      .wrap(buildAwsValue())
}
object UICustomizationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UICustomizationType =
      zio.aws.cognitoidentityprovider.model.UICustomizationType(
        userPoolId.map(value => value),
        clientId.map(value => value),
        imageUrl.map(value => value),
        css.map(value => value),
        cssVersion.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def userPoolId: Option[UserPoolIdType]
    def clientId: Option[ClientIdType]
    def imageUrl: Option[ImageUrlType]
    def css: Option[CSSType]
    def cssVersion: Option[CSSVersionType]
    def lastModifiedDate: Option[DateType]
    def creationDate: Option[DateType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getImageUrl: ZIO[Any, AwsError, ImageUrlType] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getCss: ZIO[Any, AwsError, CSSType] =
      AwsError.unwrapOptionField("css", css)
    def getCssVersion: ZIO[Any, AwsError, CSSVersionType] =
      AwsError.unwrapOptionField("cssVersion", cssVersion)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType
  ) extends zio.aws.cognitoidentityprovider.model.UICustomizationType.ReadOnly {
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val clientId: Option[ClientIdType] = scala
      .Option(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val imageUrl: Option[ImageUrlType] = scala
      .Option(impl.imageUrl())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ImageUrlType(value)
      )
    override val css: Option[CSSType] = scala
      .Option(impl.css())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.CSSType(value)
      )
    override val cssVersion: Option[CSSVersionType] = scala
      .Option(impl.cssVersion())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.CSSVersionType(value)
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType
  ): zio.aws.cognitoidentityprovider.model.UICustomizationType.ReadOnly =
    new Wrapper(impl)
}
