package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait CompromisedCredentialsEventActionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType
}
object CompromisedCredentialsEventActionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType
  ): zio.aws.cognitoidentityprovider.model.CompromisedCredentialsEventActionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.BLOCK =>
        val r = BLOCK
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.NO_ACTION =>
        val r = NO_ACTION
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.CompromisedCredentialsEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BLOCK
      extends zio.aws.cognitoidentityprovider.model.CompromisedCredentialsEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.BLOCK
  }
  case object NO_ACTION
      extends zio.aws.cognitoidentityprovider.model.CompromisedCredentialsEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsEventActionType.NO_ACTION
  }
}
