package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class GetCsvHeaderRequest(userPoolId: UserPoolIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest = {
    import GetCsvHeaderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest
      .wrap(buildAwsValue())
}
object GetCsvHeaderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest =
      zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest
  ): zio.aws.cognitoidentityprovider.model.GetCsvHeaderRequest.ReadOnly =
    new Wrapper(impl)
}
