package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  BooleanType,
  DateType,
  UsernameType
}
import scala.jdk.CollectionConverters._
final case class UserType(
    username: Option[UsernameType] = None,
    attributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    userCreateDate: Option[DateType] = None,
    userLastModifiedDate: Option[DateType] = None,
    enabled: Option[BooleanType] = None,
    userStatus: Option[zio.aws.cognitoidentityprovider.model.UserStatusType] =
      None,
    mfaOptions: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserType = {
    import UserType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserType
      .builder()
      .optionallyWith(
        username.map(value => UsernameType.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        userCreateDate.map(value => DateType.unwrap(value): Instant)
      )(_.userCreateDate)
      .optionallyWith(
        userLastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.userLastModifiedDate)
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .optionallyWith(
        mfaOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mfaOptions)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.UserType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserType.wrap(buildAwsValue())
}
object UserType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserType =
      zio.aws.cognitoidentityprovider.model.UserType(
        username.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userCreateDate.map(value => value),
        userLastModifiedDate.map(value => value),
        enabled.map(value => value),
        userStatus.map(value => value),
        mfaOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def username: Option[UsernameType]
    def attributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def userCreateDate: Option[DateType]
    def userLastModifiedDate: Option[DateType]
    def enabled: Option[BooleanType]
    def userStatus: Option[zio.aws.cognitoidentityprovider.model.UserStatusType]
    def mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ]
    def getUsername: ZIO[Any, AwsError, UsernameType] =
      AwsError.unwrapOptionField("username", username)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getUserCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userCreateDate", userCreateDate)
    def getUserLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userLastModifiedDate", userLastModifiedDate)
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getUserStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserStatusType
    ] = AwsError.unwrapOptionField("userStatus", userStatus)
    def getMfaOptions: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("mfaOptions", mfaOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserType
  ) extends zio.aws.cognitoidentityprovider.model.UserType.ReadOnly {
    override val username: Option[UsernameType] = scala
      .Option(impl.username())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UsernameType(value)
      )
    override val attributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val userCreateDate: Option[DateType] = scala
      .Option(impl.userCreateDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val userLastModifiedDate: Option[DateType] = scala
      .Option(impl.userLastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val enabled: Option[BooleanType] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val userStatus
        : Option[zio.aws.cognitoidentityprovider.model.UserStatusType] = scala
      .Option(impl.userStatus())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserStatusType.wrap(value)
      )
    override val mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ] = scala
      .Option(impl.mfaOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserType
  ): zio.aws.cognitoidentityprovider.model.UserType.ReadOnly = new Wrapper(impl)
}
