package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetUserPoolMfaConfigResponse(
    smsMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType
    ] = None,
    softwareTokenMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
    ] = None,
    mfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse = {
    import SetUserPoolMfaConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
      .builder()
      .optionallyWith(smsMfaConfiguration.map(value => value.buildAwsValue()))(
        _.smsMfaConfiguration
      )
      .optionallyWith(
        softwareTokenMfaConfiguration.map(value => value.buildAwsValue())
      )(_.softwareTokenMfaConfiguration)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
      .wrap(buildAwsValue())
}
object SetUserPoolMfaConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse =
      zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse(
        smsMfaConfiguration.map(value => value.asEditable),
        softwareTokenMfaConfiguration.map(value => value.asEditable),
        mfaConfiguration.map(value => value)
      )
    def smsMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ]
    def softwareTokenMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ]
    def mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def getSmsMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("smsMfaConfiguration", smsMfaConfiguration)
    def getSoftwareTokenMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "softwareTokenMfaConfiguration",
      softwareTokenMfaConfiguration
    )
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ) extends zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly {
    override val smsMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = scala
      .Option(impl.smsMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.wrap(value)
      )
    override val softwareTokenMfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = scala
      .Option(impl.softwareTokenMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
          .wrap(value)
      )
    override val mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] = scala
      .Option(impl.mfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
  ): zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly =
    new Wrapper(impl)
}
