package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  DeviceKeyType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminUpdateDeviceStatusRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    deviceKey: DeviceKeyType,
    deviceRememberedStatus: Option[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest = {
    import AdminUpdateDeviceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .optionallyWith(deviceRememberedStatus.map(value => value.unwrap))(
        _.deviceRememberedStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
      .wrap(buildAwsValue())
}
object AdminUpdateDeviceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest =
      zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest(
        userPoolId,
        username,
        deviceKey,
        deviceRememberedStatus.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def deviceKey: DeviceKeyType
    def deviceRememberedStatus: Option[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
    def getDeviceRememberedStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = AwsError.unwrapOptionField(
      "deviceRememberedStatus",
      deviceRememberedStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
    override val deviceRememberedStatus: Option[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = scala
      .Option(impl.deviceRememberedStatus())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
  ): zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest.ReadOnly =
    new Wrapper(impl)
}
