package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait DefaultEmailOptionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType
}
object DefaultEmailOptionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType
  ): zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.CONFIRM_WITH_LINK =>
        val r = CONFIRM_WITH_LINK
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.CONFIRM_WITH_CODE =>
        val r = CONFIRM_WITH_CODE
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIRM_WITH_LINK
      extends zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.CONFIRM_WITH_LINK
  }
  case object CONFIRM_WITH_CODE
      extends zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType.CONFIRM_WITH_CODE
  }
}
