package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  SessionType,
  SecretCodeType
}
import scala.jdk.CollectionConverters._
final case class AssociateSoftwareTokenResponse(
    secretCode: Option[SecretCodeType] = None,
    session: Option[SessionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse = {
    import AssociateSoftwareTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
      .builder()
      .optionallyWith(
        secretCode.map(value => SecretCodeType.unwrap(value): java.lang.String)
      )(_.secretCode)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
      .wrap(buildAwsValue())
}
object AssociateSoftwareTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse =
      zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse(
        secretCode.map(value => value),
        session.map(value => value)
      )
    def secretCode: Option[SecretCodeType]
    def session: Option[SessionType]
    def getSecretCode: ZIO[Any, AwsError, SecretCodeType] =
      AwsError.unwrapOptionField("secretCode", secretCode)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ) extends zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly {
    override val secretCode: Option[SecretCodeType] = scala
      .Option(impl.secretCode())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SecretCodeType(value)
      )
    override val session: Option[SessionType] = scala
      .Option(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
  ): zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly =
    new Wrapper(impl)
}
