package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  CompletionMessageType,
  DateType,
  UserPoolIdType,
  PreSignedUrlType,
  LongType,
  UserImportJobIdType,
  UserImportJobNameType
}
import scala.jdk.CollectionConverters._
final case class UserImportJobType(
    jobName: Option[UserImportJobNameType] = None,
    jobId: Option[UserImportJobIdType] = None,
    userPoolId: Option[UserPoolIdType] = None,
    preSignedUrl: Option[PreSignedUrlType] = None,
    creationDate: Option[DateType] = None,
    startDate: Option[DateType] = None,
    completionDate: Option[DateType] = None,
    status: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = None,
    cloudWatchLogsRoleArn: Option[ArnType] = None,
    importedUsers: Option[LongType] = None,
    skippedUsers: Option[LongType] = None,
    failedUsers: Option[LongType] = None,
    completionMessage: Option[CompletionMessageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType = {
    import UserImportJobType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
      .builder()
      .optionallyWith(
        jobName.map(value =>
          UserImportJobNameType.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .optionallyWith(
        jobId.map(value => UserImportJobIdType.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        preSignedUrl.map(value =>
          PreSignedUrlType.unwrap(value): java.lang.String
        )
      )(_.preSignedUrl)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(startDate.map(value => DateType.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(
        completionDate.map(value => DateType.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        cloudWatchLogsRoleArn.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsRoleArn)
      .optionallyWith(
        importedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.importedUsers)
      .optionallyWith(
        skippedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.skippedUsers)
      .optionallyWith(
        failedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.failedUsers)
      .optionallyWith(
        completionMessage.map(value =>
          CompletionMessageType.unwrap(value): java.lang.String
        )
      )(_.completionMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserImportJobType
      .wrap(buildAwsValue())
}
object UserImportJobType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserImportJobType =
      zio.aws.cognitoidentityprovider.model.UserImportJobType(
        jobName.map(value => value),
        jobId.map(value => value),
        userPoolId.map(value => value),
        preSignedUrl.map(value => value),
        creationDate.map(value => value),
        startDate.map(value => value),
        completionDate.map(value => value),
        status.map(value => value),
        cloudWatchLogsRoleArn.map(value => value),
        importedUsers.map(value => value),
        skippedUsers.map(value => value),
        failedUsers.map(value => value),
        completionMessage.map(value => value)
      )
    def jobName: Option[UserImportJobNameType]
    def jobId: Option[UserImportJobIdType]
    def userPoolId: Option[UserPoolIdType]
    def preSignedUrl: Option[PreSignedUrlType]
    def creationDate: Option[DateType]
    def startDate: Option[DateType]
    def completionDate: Option[DateType]
    def status
        : Option[zio.aws.cognitoidentityprovider.model.UserImportJobStatusType]
    def cloudWatchLogsRoleArn: Option[ArnType]
    def importedUsers: Option[LongType]
    def skippedUsers: Option[LongType]
    def failedUsers: Option[LongType]
    def completionMessage: Option[CompletionMessageType]
    def getJobName: ZIO[Any, AwsError, UserImportJobNameType] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobId: ZIO[Any, AwsError, UserImportJobIdType] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getPreSignedUrl: ZIO[Any, AwsError, PreSignedUrlType] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getStartDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getCompletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getCloudWatchLogsRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("cloudWatchLogsRoleArn", cloudWatchLogsRoleArn)
    def getImportedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("importedUsers", importedUsers)
    def getSkippedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("skippedUsers", skippedUsers)
    def getFailedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("failedUsers", failedUsers)
    def getCompletionMessage: ZIO[Any, AwsError, CompletionMessageType] =
      AwsError.unwrapOptionField("completionMessage", completionMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ) extends zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly {
    override val jobName: Option[UserImportJobNameType] = scala
      .Option(impl.jobName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .UserImportJobNameType(value)
      )
    override val jobId: Option[UserImportJobIdType] = scala
      .Option(impl.jobId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .UserImportJobIdType(value)
      )
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val preSignedUrl: Option[PreSignedUrlType] = scala
      .Option(impl.preSignedUrl())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PreSignedUrlType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val startDate: Option[DateType] = scala
      .Option(impl.startDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val completionDate: Option[DateType] = scala
      .Option(impl.completionDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val status: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
          .wrap(value)
      )
    override val cloudWatchLogsRoleArn: Option[ArnType] = scala
      .Option(impl.cloudWatchLogsRoleArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val importedUsers: Option[LongType] = scala
      .Option(impl.importedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val skippedUsers: Option[LongType] = scala
      .Option(impl.skippedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val failedUsers: Option[LongType] = scala
      .Option(impl.failedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val completionMessage: Option[CompletionMessageType] = scala
      .Option(impl.completionMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .CompletionMessageType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ): zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly =
    new Wrapper(impl)
}
