package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  PrecedenceType,
  DateType,
  UserPoolIdType,
  GroupNameType,
  DescriptionType
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GroupType(
    groupName: Option[GroupNameType] = None,
    userPoolId: Option[UserPoolIdType] = None,
    description: Option[DescriptionType] = None,
    roleArn: Option[ArnType] = None,
    precedence: Option[PrecedenceType] = None,
    lastModifiedDate: Option[DateType] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType = {
    import GroupType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
      .builder()
      .optionallyWith(
        groupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        roleArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        precedence.map(value => PrecedenceType.unwrap(value): Integer)
      )(_.precedence)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GroupType.wrap(buildAwsValue())
}
object GroupType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GroupType =
      zio.aws.cognitoidentityprovider.model.GroupType(
        groupName.map(value => value),
        userPoolId.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        precedence.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def groupName: Option[GroupNameType]
    def userPoolId: Option[UserPoolIdType]
    def description: Option[DescriptionType]
    def roleArn: Option[ArnType]
    def precedence: Option[PrecedenceType]
    def lastModifiedDate: Option[DateType]
    def creationDate: Option[DateType]
    def getGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPrecedence: ZIO[Any, AwsError, PrecedenceType] =
      AwsError.unwrapOptionField("precedence", precedence)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ) extends zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly {
    override val groupName: Option[GroupNameType] = scala
      .Option(impl.groupName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.GroupNameType(value)
      )
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DescriptionType(value)
      )
    override val roleArn: Option[ArnType] = scala
      .Option(impl.roleArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val precedence: Option[PrecedenceType] = scala
      .Option(impl.precedence())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PrecedenceType(value)
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType
  ): zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly = new Wrapper(
    impl
  )
}
