package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserImportJobIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class StopUserImportJobRequest(
    userPoolId: UserPoolIdType,
    jobId: UserImportJobIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest = {
    import StopUserImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .jobId(UserImportJobIdType.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.StopUserImportJobRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.StopUserImportJobRequest
      .wrap(buildAwsValue())
}
object StopUserImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.StopUserImportJobRequest =
      zio.aws.cognitoidentityprovider.model
        .StopUserImportJobRequest(userPoolId, jobId)
    def userPoolId: UserPoolIdType
    def jobId: UserImportJobIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getJobId: ZIO[Any, Nothing, UserImportJobIdType] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest
  ) extends zio.aws.cognitoidentityprovider.model.StopUserImportJobRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val jobId: UserImportJobIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserImportJobIdType(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest
  ): zio.aws.cognitoidentityprovider.model.StopUserImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
