package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateIdentityProviderResponse(
    identityProvider: zio.aws.cognitoidentityprovider.model.IdentityProviderType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse = {
    import CreateIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse
      .builder()
      .identityProvider(identityProvider.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse
      .wrap(buildAwsValue())
}
object CreateIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse =
      zio.aws.cognitoidentityprovider.model
        .CreateIdentityProviderResponse(identityProvider.asEditable)
    def identityProvider
        : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly
    ] = ZIO.succeed(identityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly {
    override val identityProvider
        : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.IdentityProviderType
        .wrap(impl.identityProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse
  ): zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly =
    new Wrapper(impl)
}
