package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PasswordType,
  ConfirmationCodeType,
  SecretHashType,
  UsernameType,
  ClientIdType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class ConfirmForgotPasswordRequest(
    clientId: ClientIdType,
    secretHash: Option[SecretHashType] = None,
    username: UsernameType,
    confirmationCode: ConfirmationCodeType,
    password: PasswordType,
    analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = None,
    userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = None,
    clientMetadata: Option[Map[StringType, StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest = {
    import ConfirmForgotPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
      .builder()
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(
        secretHash.map(value => SecretHashType.unwrap(value): java.lang.String)
      )(_.secretHash)
      .username(UsernameType.unwrap(username): java.lang.String)
      .confirmationCode(
        ConfirmationCodeType.unwrap(confirmationCode): java.lang.String
      )
      .password(PasswordType.unwrap(password): java.lang.String)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
      .wrap(buildAwsValue())
}
object ConfirmForgotPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest =
      zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest(
        clientId,
        secretHash.map(value => value),
        username,
        confirmationCode,
        password,
        analyticsMetadata.map(value => value.asEditable),
        userContextData.map(value => value.asEditable),
        clientMetadata.map(value => value)
      )
    def clientId: ClientIdType
    def secretHash: Option[SecretHashType]
    def username: UsernameType
    def confirmationCode: ConfirmationCodeType
    def password: PasswordType
    def analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def clientMetadata: Option[Map[StringType, StringType]]
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getSecretHash: ZIO[Any, AwsError, SecretHashType] =
      AwsError.unwrapOptionField("secretHash", secretHash)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getConfirmationCode: ZIO[Any, Nothing, ConfirmationCodeType] =
      ZIO.succeed(confirmationCode)
    def getPassword: ZIO[Any, Nothing, PasswordType] = ZIO.succeed(password)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
  ) extends zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest.ReadOnly {
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val secretHash: Option[SecretHashType] = scala
      .Option(impl.secretHash())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SecretHashType(value)
      )
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val confirmationCode: ConfirmationCodeType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ConfirmationCodeType(impl.confirmationCode())
    override val password: PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PasswordType(impl.password())
    override val analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = scala
      .Option(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = scala
      .Option(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
  ): zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
