package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  ResourceServerNameType,
  ResourceServerIdentifierType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class ResourceServerType(
    userPoolId: Option[UserPoolIdType] = None,
    identifier: Option[ResourceServerIdentifierType] = None,
    name: Option[ResourceServerNameType] = None,
    scopes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.ResourceServerScopeType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType = {
    import ResourceServerType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        identifier.map(value =>
          ResourceServerIdentifierType.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(
        name.map(value =>
          ResourceServerNameType.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scopes)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ResourceServerType
      .wrap(buildAwsValue())
}
object ResourceServerType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ResourceServerType =
      zio.aws.cognitoidentityprovider.model.ResourceServerType(
        userPoolId.map(value => value),
        identifier.map(value => value),
        name.map(value => value),
        scopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userPoolId: Option[UserPoolIdType]
    def identifier: Option[ResourceServerIdentifierType]
    def name: Option[ResourceServerNameType]
    def scopes: Option[List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getIdentifier: ZIO[Any, AwsError, ResourceServerIdentifierType] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getName: ZIO[Any, AwsError, ResourceServerNameType] =
      AwsError.unwrapOptionField("name", name)
    def getScopes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]] = AwsError.unwrapOptionField("scopes", scopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType
  ) extends zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly {
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val identifier: Option[ResourceServerIdentifierType] = scala
      .Option(impl.identifier())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ResourceServerIdentifierType(value)
      )
    override val name: Option[ResourceServerNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ResourceServerNameType(value)
      )
    override val scopes: Option[List[
      zio.aws.cognitoidentityprovider.model.ResourceServerScopeType.ReadOnly
    ]] = scala
      .Option(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.ResourceServerScopeType
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType
  ): zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly =
    new Wrapper(impl)
}
