package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class InitiateAuthRequest(
    authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType,
    authParameters: Option[Map[StringType, StringType]] = None,
    clientMetadata: Option[Map[StringType, StringType]] = None,
    clientId: ClientIdType,
    analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = None,
    userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest = {
    import InitiateAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
      .builder()
      .authFlow(authFlow.unwrap)
      .optionallyWith(
        authParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.authParameters)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.InitiateAuthRequest
      .wrap(buildAwsValue())
}
object InitiateAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.InitiateAuthRequest =
      zio.aws.cognitoidentityprovider.model.InitiateAuthRequest(
        authFlow,
        authParameters.map(value => value),
        clientMetadata.map(value => value),
        clientId,
        analyticsMetadata.map(value => value.asEditable),
        userContextData.map(value => value.asEditable)
      )
    def authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType
    def authParameters: Option[Map[StringType, StringType]]
    def clientMetadata: Option[Map[StringType, StringType]]
    def clientId: ClientIdType
    def analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def getAuthFlow: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.AuthFlowType
    ] = ZIO.succeed(authFlow)
    def getAuthParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("authParameters", authParameters)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ) extends zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly {
    override val authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType =
      zio.aws.cognitoidentityprovider.model.AuthFlowType.wrap(impl.authFlow())
    override val authParameters: Option[Map[StringType, StringType]] = scala
      .Option(impl.authParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = scala
      .Option(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val userContextData: Option[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = scala
      .Option(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ): zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly =
    new Wrapper(impl)
}
