package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{DateType, StringType}
import scala.jdk.CollectionConverters._
final case class AuthEventType(
    eventId: Option[StringType] = None,
    eventType: Option[zio.aws.cognitoidentityprovider.model.EventType] = None,
    creationDate: Option[DateType] = None,
    eventResponse: Option[
      zio.aws.cognitoidentityprovider.model.EventResponseType
    ] = None,
    eventRisk: Option[zio.aws.cognitoidentityprovider.model.EventRiskType] =
      None,
    challengeResponses: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.ChallengeResponseType]
    ] = None,
    eventContextData: Option[
      zio.aws.cognitoidentityprovider.model.EventContextDataType
    ] = None,
    eventFeedback: Option[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType = {
    import AuthEventType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
      .builder()
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(eventResponse.map(value => value.unwrap))(_.eventResponse)
      .optionallyWith(eventRisk.map(value => value.buildAwsValue()))(
        _.eventRisk
      )
      .optionallyWith(
        challengeResponses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.challengeResponses)
      .optionallyWith(eventContextData.map(value => value.buildAwsValue()))(
        _.eventContextData
      )
      .optionallyWith(eventFeedback.map(value => value.buildAwsValue()))(
        _.eventFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AuthEventType.wrap(buildAwsValue())
}
object AuthEventType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.AuthEventType =
      zio.aws.cognitoidentityprovider.model.AuthEventType(
        eventId.map(value => value),
        eventType.map(value => value),
        creationDate.map(value => value),
        eventResponse.map(value => value),
        eventRisk.map(value => value.asEditable),
        challengeResponses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        eventContextData.map(value => value.asEditable),
        eventFeedback.map(value => value.asEditable)
      )
    def eventId: Option[StringType]
    def eventType: Option[zio.aws.cognitoidentityprovider.model.EventType]
    def creationDate: Option[DateType]
    def eventResponse
        : Option[zio.aws.cognitoidentityprovider.model.EventResponseType]
    def eventRisk
        : Option[zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly]
    def challengeResponses: Option[
      List[zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly]
    ]
    def eventContextData: Option[
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ]
    def eventFeedback: Option[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ]
    def getEventId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEventResponse: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventResponseType
    ] = AwsError.unwrapOptionField("eventResponse", eventResponse)
    def getEventRisk: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly
    ] = AwsError.unwrapOptionField("eventRisk", eventRisk)
    def getChallengeResponses: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly
    ]] = AwsError.unwrapOptionField("challengeResponses", challengeResponses)
    def getEventContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("eventContextData", eventContextData)
    def getEventFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ] = AwsError.unwrapOptionField("eventFeedback", eventFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ) extends zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly {
    override val eventId: Option[StringType] =
      scala.Option(impl.eventId()).map(value => value: StringType)
    override val eventType
        : Option[zio.aws.cognitoidentityprovider.model.EventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.cognitoidentityprovider.model.EventType.wrap(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val eventResponse
        : Option[zio.aws.cognitoidentityprovider.model.EventResponseType] =
      scala
        .Option(impl.eventResponse())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.EventResponseType.wrap(value)
        )
    override val eventRisk
        : Option[zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly] =
      scala
        .Option(impl.eventRisk())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.EventRiskType.wrap(value)
        )
    override val challengeResponses: Option[
      List[zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly]
    ] = scala
      .Option(impl.challengeResponses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.ChallengeResponseType.wrap(item)
        }.toList
      )
    override val eventContextData: Option[
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ] = scala
      .Option(impl.eventContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EventContextDataType.wrap(value)
      )
    override val eventFeedback: Option[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ] = scala
      .Option(impl.eventFeedback())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EventFeedbackType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ): zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly = new Wrapper(
    impl
  )
}
