package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  PrecedenceType,
  UserPoolIdType,
  GroupNameType,
  DescriptionType
}
import scala.jdk.CollectionConverters._
final case class UpdateGroupRequest(
    groupName: GroupNameType,
    userPoolId: UserPoolIdType,
    description: Option[DescriptionType] = None,
    roleArn: Option[ArnType] = None,
    precedence: Option[PrecedenceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest = {
    import UpdateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        roleArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        precedence.map(value => PrecedenceType.unwrap(value): Integer)
      )(_.precedence)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateGroupRequest
      .wrap(buildAwsValue())
}
object UpdateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UpdateGroupRequest =
      zio.aws.cognitoidentityprovider.model.UpdateGroupRequest(
        groupName,
        userPoolId,
        description.map(value => value),
        roleArn.map(value => value),
        precedence.map(value => value)
      )
    def groupName: GroupNameType
    def userPoolId: UserPoolIdType
    def description: Option[DescriptionType]
    def roleArn: Option[ArnType]
    def precedence: Option[PrecedenceType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPrecedence: ZIO[Any, AwsError, PrecedenceType] =
      AwsError.unwrapOptionField("precedence", precedence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DescriptionType(value)
      )
    override val roleArn: Option[ArnType] = scala
      .Option(impl.roleArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val precedence: Option[PrecedenceType] = scala
      .Option(impl.precedence())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PrecedenceType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateGroupRequest.ReadOnly =
    new Wrapper(impl)
}
