package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  DomainVersionType,
  UserPoolIdType,
  S3BucketType,
  AWSAccountIdType,
  StringType,
  DomainType
}
import scala.jdk.CollectionConverters._
final case class DomainDescriptionType(
    userPoolId: Option[UserPoolIdType] = None,
    awsAccountId: Option[AWSAccountIdType] = None,
    domain: Option[DomainType] = None,
    s3Bucket: Option[S3BucketType] = None,
    cloudFrontDistribution: Option[StringType] = None,
    version: Option[DomainVersionType] = None,
    status: Option[zio.aws.cognitoidentityprovider.model.DomainStatusType] =
      None,
    customDomainConfig: Option[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType = {
    import DomainDescriptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        awsAccountId.map(value =>
          AWSAccountIdType.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .optionallyWith(
        domain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        s3Bucket.map(value => S3BucketType.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        cloudFrontDistribution.map(value => value: java.lang.String)
      )(_.cloudFrontDistribution)
      .optionallyWith(
        version.map(value => DomainVersionType.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(customDomainConfig.map(value => value.buildAwsValue()))(
        _.customDomainConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DomainDescriptionType
      .wrap(buildAwsValue())
}
object DomainDescriptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DomainDescriptionType =
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType(
        userPoolId.map(value => value),
        awsAccountId.map(value => value),
        domain.map(value => value),
        s3Bucket.map(value => value),
        cloudFrontDistribution.map(value => value),
        version.map(value => value),
        status.map(value => value),
        customDomainConfig.map(value => value.asEditable)
      )
    def userPoolId: Option[UserPoolIdType]
    def awsAccountId: Option[AWSAccountIdType]
    def domain: Option[DomainType]
    def s3Bucket: Option[S3BucketType]
    def cloudFrontDistribution: Option[StringType]
    def version: Option[DomainVersionType]
    def status: Option[zio.aws.cognitoidentityprovider.model.DomainStatusType]
    def customDomainConfig: Option[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getAwsAccountId: ZIO[Any, AwsError, AWSAccountIdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getS3Bucket: ZIO[Any, AwsError, S3BucketType] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getCloudFrontDistribution: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("cloudFrontDistribution", cloudFrontDistribution)
    def getVersion: ZIO[Any, AwsError, DomainVersionType] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DomainStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getCustomDomainConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("customDomainConfig", customDomainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ) extends zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly {
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val awsAccountId: Option[AWSAccountIdType] = scala
      .Option(impl.awsAccountId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.AWSAccountIdType(value)
      )
    override val domain: Option[DomainType] = scala
      .Option(impl.domain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val s3Bucket: Option[S3BucketType] = scala
      .Option(impl.s3Bucket())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.S3BucketType(value)
      )
    override val cloudFrontDistribution: Option[StringType] = scala
      .Option(impl.cloudFrontDistribution())
      .map(value => value: StringType)
    override val version: Option[DomainVersionType] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .DomainVersionType(value)
      )
    override val status
        : Option[zio.aws.cognitoidentityprovider.model.DomainStatusType] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DomainStatusType.wrap(value)
      )
    override val customDomainConfig: Option[
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = scala
      .Option(impl.customDomainConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType
  ): zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly =
    new Wrapper(impl)
}
