package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class ConfirmDeviceResponse(
    userConfirmationNecessary: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse = {
    import ConfirmDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
      .builder()
      .optionallyWith(
        userConfirmationNecessary.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.userConfirmationNecessary)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse
      .wrap(buildAwsValue())
}
object ConfirmDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse =
      zio.aws.cognitoidentityprovider.model
        .ConfirmDeviceResponse(userConfirmationNecessary.map(value => value))
    def userConfirmationNecessary: Option[BooleanType]
    def getUserConfirmationNecessary: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("userConfirmationNecessary", userConfirmationNecessary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ) extends zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly {
    override val userConfirmationNecessary: Option[BooleanType] = scala
      .Option(impl.userConfirmationNecessary())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ): zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
