package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class GetSigningCertificateResponse(
    certificate: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse = {
    import GetSigningCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
      .builder()
      .optionallyWith(
        certificate.map(value => StringType.unwrap(value): java.lang.String)
      )(_.certificate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse
      .wrap(buildAwsValue())
}
object GetSigningCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse =
      zio.aws.cognitoidentityprovider.model
        .GetSigningCertificateResponse(certificate.map(value => value))
    def certificate: Option[StringType]
    def getCertificate: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly {
    override val certificate: Option[StringType] = scala
      .Option(impl.certificate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ): zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
