package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolClientResponse(
    userPoolClient: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse = {
    import DescribeUserPoolClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse
      .builder()
      .optionallyWith(userPoolClient.map(value => value.buildAwsValue()))(
        _.userPoolClient
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse
      .wrap(buildAwsValue())
}
object DescribeUserPoolClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse =
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse(
        userPoolClient.map(value => value.asEditable)
      )
    def userPoolClient: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ]
    def getUserPoolClient: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolClient", userPoolClient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly {
    override val userPoolClient: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolClientType.ReadOnly
    ] = scala
      .Option(impl.userPoolClient())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolClientType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly =
    new Wrapper(impl)
}
