package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminInitiateAuthRequest(
    userPoolId: UserPoolIdType,
    clientId: ClientIdType,
    authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType,
    authParameters: Option[Map[StringType, StringType]] = None,
    clientMetadata: Option[Map[StringType, StringType]] = None,
    analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = None,
    contextData: Option[zio.aws.cognitoidentityprovider.model.ContextDataType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest = {
    import AdminInitiateAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .authFlow(authFlow.unwrap)
      .optionallyWith(
        authParameters.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.authParameters)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(contextData.map(value => value.buildAwsValue()))(
        _.contextData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest
      .wrap(buildAwsValue())
}
object AdminInitiateAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest =
      zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest(
        userPoolId,
        clientId,
        authFlow,
        authParameters.map(value => value),
        clientMetadata.map(value => value),
        analyticsMetadata.map(value => value.asEditable),
        contextData.map(value => value.asEditable)
      )
    def userPoolId: UserPoolIdType
    def clientId: ClientIdType
    def authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType
    def authParameters: Option[Map[StringType, StringType]]
    def clientMetadata: Option[Map[StringType, StringType]]
    def analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def contextData
        : Option[zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getAuthFlow: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.AuthFlowType
    ] = ZIO.succeed(authFlow)
    def getAuthParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("authParameters", authParameters)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("contextData", contextData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType =
      zio.aws.cognitoidentityprovider.model.AuthFlowType.wrap(impl.authFlow())
    override val authParameters: Option[Map[StringType, StringType]] = scala
      .Option(impl.authParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.StringType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .StringType(value)
          })
          .toMap
      )
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.StringType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .StringType(value)
          })
          .toMap
      )
    override val analyticsMetadata: Option[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = scala
      .Option(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val contextData: Option[
      zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly
    ] = scala
      .Option(impl.contextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.ContextDataType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest
  ): zio.aws.cognitoidentityprovider.model.AdminInitiateAuthRequest.ReadOnly =
    new Wrapper(impl)
}
