package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeNameType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class CodeDeliveryDetailsType(
    destination: Option[StringType] = None,
    deliveryMedium: Option[
      zio.aws.cognitoidentityprovider.model.DeliveryMediumType
    ] = None,
    attributeName: Option[AttributeNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType = {
    import CodeDeliveryDetailsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType
      .builder()
      .optionallyWith(
        destination.map(value => StringType.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(deliveryMedium.map(value => value.unwrap))(
        _.deliveryMedium
      )
      .optionallyWith(
        attributeName.map(value =>
          AttributeNameType.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
      .wrap(buildAwsValue())
}
object CodeDeliveryDetailsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType =
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType(
        destination.map(value => value),
        deliveryMedium.map(value => value),
        attributeName.map(value => value)
      )
    def destination: Option[StringType]
    def deliveryMedium
        : Option[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]
    def attributeName: Option[AttributeNameType]
    def getDestination: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("destination", destination)
    def getDeliveryMedium: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeliveryMediumType
    ] = AwsError.unwrapOptionField("deliveryMedium", deliveryMedium)
    def getAttributeName: ZIO[Any, AwsError, AttributeNameType] =
      AwsError.unwrapOptionField("attributeName", attributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType
  ) extends zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly {
    override val destination: Option[StringType] = scala
      .Option(impl.destination())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
    override val deliveryMedium
        : Option[zio.aws.cognitoidentityprovider.model.DeliveryMediumType] =
      scala
        .Option(impl.deliveryMedium())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.DeliveryMediumType.wrap(value)
        )
    override val attributeName: Option[AttributeNameType] = scala
      .Option(impl.attributeName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .AttributeNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType
  ): zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly =
    new Wrapper(impl)
}
