package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  GroupNameType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminAddUserToGroupRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    groupName: GroupNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest = {
    import AdminAddUserToGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminAddUserToGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminAddUserToGroupRequest
      .wrap(buildAwsValue())
}
object AdminAddUserToGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminAddUserToGroupRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminAddUserToGroupRequest(userPoolId, username, groupName)
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def groupName: GroupNameType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminAddUserToGroupRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest
  ): zio.aws.cognitoidentityprovider.model.AdminAddUserToGroupRequest.ReadOnly =
    new Wrapper(impl)
}
