package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SessionType
}
import scala.jdk.CollectionConverters._
final case class RespondToAuthChallengeResponse(
    challengeName: Option[
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = None,
    session: Option[SessionType] = None,
    challengeParameters: Option[Map[StringType, StringType]] = None,
    authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse = {
    import RespondToAuthChallengeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
      .builder()
      .optionallyWith(challengeName.map(value => value.unwrap))(_.challengeName)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .optionallyWith(
        challengeParameters.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.challengeParameters)
      .optionallyWith(authenticationResult.map(value => value.buildAwsValue()))(
        _.authenticationResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse
      .wrap(buildAwsValue())
}
object RespondToAuthChallengeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse =
      zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse(
        challengeName.map(value => value),
        session.map(value => value),
        challengeParameters.map(value => value),
        authenticationResult.map(value => value.asEditable)
      )
    def challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeNameType]
    def session: Option[SessionType]
    def challengeParameters: Option[Map[StringType, StringType]]
    def authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ]
    def getChallengeName: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = AwsError.unwrapOptionField("challengeName", challengeName)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getChallengeParameters
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("challengeParameters", challengeParameters)
    def getAuthenticationResult: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationResult", authenticationResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
  ) extends zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly {
    override val challengeName
        : Option[zio.aws.cognitoidentityprovider.model.ChallengeNameType] =
      scala
        .Option(impl.challengeName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.ChallengeNameType.wrap(value)
        )
    override val session: Option[SessionType] = scala
      .Option(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val challengeParameters: Option[Map[StringType, StringType]] =
      scala
        .Option(impl.challengeParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives.StringType(
                key
              ) -> zio.aws.cognitoidentityprovider.model.primitives
                .StringType(value)
            })
            .toMap
        )
    override val authenticationResult: Option[
      zio.aws.cognitoidentityprovider.model.AuthenticationResultType.ReadOnly
    ] = scala
      .Option(impl.authenticationResult())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AuthenticationResultType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
  ): zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly =
    new Wrapper(impl)
}
