package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolDomainResponse(
    domainDescription: Option[
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse = {
    import DescribeUserPoolDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
      .builder()
      .optionallyWith(domainDescription.map(value => value.buildAwsValue()))(
        _.domainDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
      .wrap(buildAwsValue())
}
object DescribeUserPoolDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse =
      zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse(
        domainDescription.map(value => value.asEditable)
      )
    def domainDescription: Option[
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly
    ]
    def getDomainDescription: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly
    ] = AwsError.unwrapOptionField("domainDescription", domainDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly {
    override val domainDescription: Option[
      zio.aws.cognitoidentityprovider.model.DomainDescriptionType.ReadOnly
    ] = scala
      .Option(impl.domainDescription())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DomainDescriptionType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly =
    new Wrapper(impl)
}
