package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  SearchPaginationTokenType,
  QueryLimitType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminListDevicesRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    limit: Option[QueryLimitType] = None,
    paginationToken: Option[SearchPaginationTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest = {
    import AdminListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest
      .wrap(buildAwsValue())
}
object AdminListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest =
      zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest(
        userPoolId,
        username,
        limit.map(value => value),
        paginationToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def limit: Option[QueryLimitType]
    def paginationToken: Option[SearchPaginationTokenType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val limit: Option[QueryLimitType] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest
  ): zio.aws.cognitoidentityprovider.model.AdminListDevicesRequest.ReadOnly =
    new Wrapper(impl)
}
