package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class NumberAttributeConstraintsType(
    minValue: Option[StringType] = None,
    maxValue: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType = {
    import NumberAttributeConstraintsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
      .builder()
      .optionallyWith(
        minValue.map(value => StringType.unwrap(value): java.lang.String)
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value => StringType.unwrap(value): java.lang.String)
      )(_.maxValue)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType
      .wrap(buildAwsValue())
}
object NumberAttributeConstraintsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType =
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType(
        minValue.map(value => value),
        maxValue.map(value => value)
      )
    def minValue: Option[StringType]
    def maxValue: Option[StringType]
    def getMinValue: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("maxValue", maxValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ) extends zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly {
    override val minValue: Option[StringType] = scala
      .Option(impl.minValue())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
    override val maxValue: Option[StringType] = scala
      .Option(impl.maxValue())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ): zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly =
    new Wrapper(impl)
}
