package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.DomainType
import scala.jdk.CollectionConverters._
final case class CreateUserPoolDomainResponse(
    cloudFrontDomain: Option[DomainType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse = {
    import CreateUserPoolDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse
      .builder()
      .optionallyWith(
        cloudFrontDomain.map(value =>
          DomainType.unwrap(value): java.lang.String
        )
      )(_.cloudFrontDomain)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse
      .wrap(buildAwsValue())
}
object CreateUserPoolDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse =
      zio.aws.cognitoidentityprovider.model
        .CreateUserPoolDomainResponse(cloudFrontDomain.map(value => value))
    def cloudFrontDomain: Option[DomainType]
    def getCloudFrontDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("cloudFrontDomain", cloudFrontDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly {
    override val cloudFrontDomain: Option[DomainType] = scala
      .Option(impl.cloudFrontDomain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse
  ): zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly =
    new Wrapper(impl)
}
