package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourceServerResponse(
    resourceServer: zio.aws.cognitoidentityprovider.model.ResourceServerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse = {
    import DescribeResourceServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse
      .builder()
      .resourceServer(resourceServer.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse
      .wrap(buildAwsValue())
}
object DescribeResourceServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse =
      zio.aws.cognitoidentityprovider.model
        .DescribeResourceServerResponse(resourceServer.asEditable)
    def resourceServer
        : zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    def getResourceServer: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
    ] = ZIO.succeed(resourceServer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly {
    override val resourceServer
        : zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.ResourceServerType
        .wrap(impl.resourceServer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly =
    new Wrapper(impl)
}
