package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait ChallengeResponse {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse
}
object ChallengeResponse {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse
  ): zio.aws.cognitoidentityprovider.model.ChallengeResponse = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.FAILURE =>
      val r = Failure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.ChallengeResponse {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.UNKNOWN_TO_SDK_VERSION
  }
  case object Success
      extends zio.aws.cognitoidentityprovider.model.ChallengeResponse {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.SUCCESS
  }
  case object Failure
      extends zio.aws.cognitoidentityprovider.model.ChallengeResponse {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse.FAILURE
  }
}
