package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  DeviceKeyType
}
import scala.jdk.CollectionConverters._
final case class NewDeviceMetadataType(
    deviceKey: Option[DeviceKeyType] = None,
    deviceGroupKey: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType = {
    import NewDeviceMetadataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType
      .builder()
      .optionallyWith(
        deviceKey.map(value => DeviceKeyType.unwrap(value): java.lang.String)
      )(_.deviceKey)
      .optionallyWith(
        deviceGroupKey.map(value => StringType.unwrap(value): java.lang.String)
      )(_.deviceGroupKey)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType
      .wrap(buildAwsValue())
}
object NewDeviceMetadataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType =
      zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType(
        deviceKey.map(value => value),
        deviceGroupKey.map(value => value)
      )
    def deviceKey: Option[DeviceKeyType]
    def deviceGroupKey: Option[StringType]
    def getDeviceKey: ZIO[Any, AwsError, DeviceKeyType] =
      AwsError.unwrapOptionField("deviceKey", deviceKey)
    def getDeviceGroupKey: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("deviceGroupKey", deviceGroupKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType
  ) extends zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly {
    override val deviceKey: Option[DeviceKeyType] = scala
      .Option(impl.deviceKey())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DeviceKeyType(value)
      )
    override val deviceGroupKey: Option[StringType] = scala
      .Option(impl.deviceGroupKey())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType
  ): zio.aws.cognitoidentityprovider.model.NewDeviceMetadataType.ReadOnly =
    new Wrapper(impl)
}
