package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  AttributeNameType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class GetUserAttributeVerificationCodeRequest(
    accessToken: TokenModelType,
    attributeName: AttributeNameType,
    clientMetadata: Option[Map[StringType, StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest = {
    import GetUserAttributeVerificationCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .attributeName(AttributeNameType.unwrap(attributeName): java.lang.String)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
      .wrap(buildAwsValue())
}
object GetUserAttributeVerificationCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest =
      zio.aws.cognitoidentityprovider.model
        .GetUserAttributeVerificationCodeRequest(
          accessToken,
          attributeName,
          clientMetadata.map(value => value)
        )
    def accessToken: TokenModelType
    def attributeName: AttributeNameType
    def clientMetadata: Option[Map[StringType, StringType]]
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getAttributeName: ZIO[Any, Nothing, AttributeNameType] =
      ZIO.succeed(attributeName)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val attributeName: AttributeNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .AttributeNameType(impl.attributeName())
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.StringType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .StringType(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
  ): zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest.ReadOnly =
    new Wrapper(impl)
}
