package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class DeviceConfigurationType(
    challengeRequiredOnNewDevice: Option[BooleanType] = None,
    deviceOnlyRememberedOnUserPrompt: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType = {
    import DeviceConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType
      .builder()
      .optionallyWith(
        challengeRequiredOnNewDevice.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.challengeRequiredOnNewDevice)
      .optionallyWith(
        deviceOnlyRememberedOnUserPrompt.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.deviceOnlyRememberedOnUserPrompt)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
      .wrap(buildAwsValue())
}
object DeviceConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeviceConfigurationType =
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType(
        challengeRequiredOnNewDevice.map(value => value),
        deviceOnlyRememberedOnUserPrompt.map(value => value)
      )
    def challengeRequiredOnNewDevice: Option[BooleanType]
    def deviceOnlyRememberedOnUserPrompt: Option[BooleanType]
    def getChallengeRequiredOnNewDevice: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "challengeRequiredOnNewDevice",
        challengeRequiredOnNewDevice
      )
    def getDeviceOnlyRememberedOnUserPrompt: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "deviceOnlyRememberedOnUserPrompt",
        deviceOnlyRememberedOnUserPrompt
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly {
    override val challengeRequiredOnNewDevice: Option[BooleanType] = scala
      .Option(impl.challengeRequiredOnNewDevice())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val deviceOnlyRememberedOnUserPrompt: Option[BooleanType] = scala
      .Option(impl.deviceOnlyRememberedOnUserPrompt())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType
  ): zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly =
    new Wrapper(impl)
}
