package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class AdminListUserAuthEventsResponse(
    authEvents: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AuthEventType]
    ] = None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse = {
    import AdminListUserAuthEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
      .builder()
      .optionallyWith(
        authEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authEvents)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
      .wrap(buildAwsValue())
}
object AdminListUserAuthEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse =
      zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse(
        authEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def authEvents: Option[
      List[zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly]
    ]
    def nextToken: Option[PaginationKey]
    def getAuthEvents: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
    ]] = AwsError.unwrapOptionField("authEvents", authEvents)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly {
    override val authEvents: Option[
      List[zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly]
    ] = scala
      .Option(impl.authEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AuthEventType.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ): zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly =
    new Wrapper(impl)
}
