package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class ListGroupsResponse(
    groups: Option[Iterable[zio.aws.cognitoidentityprovider.model.GroupType]] =
      None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse = {
    import ListGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListGroupsResponse
      .wrap(buildAwsValue())
}
object ListGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListGroupsResponse =
      zio.aws.cognitoidentityprovider.model.ListGroupsResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groups
        : Option[List[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]]
    def nextToken: Option[PaginationKey]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly {
    override val groups: Option[
      List[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]
    ] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.GroupType.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse
  ): zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
