package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUserImportJobResponse(
    userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse = {
    import CreateUserImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse
      .builder()
      .optionallyWith(userImportJob.map(value => value.buildAwsValue()))(
        _.userImportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse
      .wrap(buildAwsValue())
}
object CreateUserImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse =
      zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse(
        userImportJob.map(value => value.asEditable)
      )
    def userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ]
    def getUserImportJob: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = AwsError.unwrapOptionField("userImportJob", userImportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly {
    override val userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = scala
      .Option(impl.userImportJob())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse
  ): zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
