package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  AdminCreateUserUnusedAccountValidityDaysType,
  BooleanType
}
import scala.jdk.CollectionConverters._
final case class AdminCreateUserConfigType(
    allowAdminCreateUserOnly: Option[BooleanType] = None,
    unusedAccountValidityDays: Option[
      AdminCreateUserUnusedAccountValidityDaysType
    ] = None,
    inviteMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.MessageTemplateType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType = {
    import AdminCreateUserConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType
      .builder()
      .optionallyWith(
        allowAdminCreateUserOnly.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowAdminCreateUserOnly)
      .optionallyWith(
        unusedAccountValidityDays.map(value =>
          AdminCreateUserUnusedAccountValidityDaysType.unwrap(value): Integer
        )
      )(_.unusedAccountValidityDays)
      .optionallyWith(
        inviteMessageTemplate.map(value => value.buildAwsValue())
      )(_.inviteMessageTemplate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
      .wrap(buildAwsValue())
}
object AdminCreateUserConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType =
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType(
        allowAdminCreateUserOnly.map(value => value),
        unusedAccountValidityDays.map(value => value),
        inviteMessageTemplate.map(value => value.asEditable)
      )
    def allowAdminCreateUserOnly: Option[BooleanType]
    def unusedAccountValidityDays
        : Option[AdminCreateUserUnusedAccountValidityDaysType]
    def inviteMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly
    ]
    def getAllowAdminCreateUserOnly: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("allowAdminCreateUserOnly", allowAdminCreateUserOnly)
    def getUnusedAccountValidityDays
        : ZIO[Any, AwsError, AdminCreateUserUnusedAccountValidityDaysType] =
      AwsError.unwrapOptionField(
        "unusedAccountValidityDays",
        unusedAccountValidityDays
      )
    def getInviteMessageTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly
    ] =
      AwsError.unwrapOptionField("inviteMessageTemplate", inviteMessageTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType
  ) extends zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly {
    override val allowAdminCreateUserOnly: Option[BooleanType] = scala
      .Option(impl.allowAdminCreateUserOnly())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val unusedAccountValidityDays
        : Option[AdminCreateUserUnusedAccountValidityDaysType] = scala
      .Option(impl.unusedAccountValidityDays())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .AdminCreateUserUnusedAccountValidityDaysType(value)
      )
    override val inviteMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.MessageTemplateType.ReadOnly
    ] = scala
      .Option(impl.inviteMessageTemplate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.MessageTemplateType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType
  ): zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly =
    new Wrapper(impl)
}
