package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class UserContextDataType(encodedData: Option[StringType] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType = {
    import UserContextDataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
      .builder()
      .optionallyWith(
        encodedData.map(value => StringType.unwrap(value): java.lang.String)
      )(_.encodedData)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserContextDataType
      .wrap(buildAwsValue())
}
object UserContextDataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserContextDataType =
      zio.aws.cognitoidentityprovider.model
        .UserContextDataType(encodedData.map(value => value))
    def encodedData: Option[StringType]
    def getEncodedData: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("encodedData", encodedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ) extends zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly {
    override val encodedData: Option[StringType] = scala
      .Option(impl.encodedData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType
  ): zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly =
    new Wrapper(impl)
}
