package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeValueType,
  AttributeNameType
}
import scala.jdk.CollectionConverters._
final case class AttributeType(
    name: AttributeNameType,
    value: Option[AttributeValueType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType = {
    import AttributeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType
      .builder()
      .name(AttributeNameType.unwrap(name): java.lang.String)
      .optionallyWith(
        value.map(value => AttributeValueType.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AttributeType.wrap(buildAwsValue())
}
object AttributeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.AttributeType =
      zio.aws.cognitoidentityprovider.model
        .AttributeType(name, value.map(value => value))
    def name: AttributeNameType
    def value: Option[AttributeValueType]
    def getName: ZIO[Any, Nothing, AttributeNameType] = ZIO.succeed(name)
    def getValue: ZIO[Any, AwsError, AttributeValueType] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType
  ) extends zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly {
    override val name: AttributeNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .AttributeNameType(impl.name())
    override val value: Option[AttributeValueType] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .AttributeValueType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType
  ): zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly = new Wrapper(
    impl
  )
}
