package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  TokenModelType,
  EventIdType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class UpdateAuthEventFeedbackRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    eventId: EventIdType,
    feedbackToken: TokenModelType,
    feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest = {
    import UpdateAuthEventFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .eventId(EventIdType.unwrap(eventId): java.lang.String)
      .feedbackToken(TokenModelType.unwrap(feedbackToken): java.lang.String)
      .feedbackValue(feedbackValue.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
      .wrap(buildAwsValue())
}
object UpdateAuthEventFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest =
      zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest(
        userPoolId,
        username,
        eventId,
        feedbackToken,
        feedbackValue
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def eventId: EventIdType
    def feedbackToken: TokenModelType
    def feedbackValue: zio.aws.cognitoidentityprovider.model.FeedbackValueType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getEventId: ZIO[Any, Nothing, EventIdType] = ZIO.succeed(eventId)
    def getFeedbackToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(feedbackToken)
    def getFeedbackValue: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
    ] = ZIO.succeed(feedbackValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val eventId: EventIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .EventIdType(impl.eventId())
    override val feedbackToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.feedbackToken())
    override val feedbackValue
        : zio.aws.cognitoidentityprovider.model.FeedbackValueType =
      zio.aws.cognitoidentityprovider.model.FeedbackValueType
        .wrap(impl.feedbackValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
