package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUserPoolResponse(
    userPool: Option[zio.aws.cognitoidentityprovider.model.UserPoolType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse = {
    import CreateUserPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse
      .builder()
      .optionallyWith(userPool.map(value => value.buildAwsValue()))(_.userPool)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse
      .wrap(buildAwsValue())
}
object CreateUserPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse =
      zio.aws.cognitoidentityprovider.model
        .CreateUserPoolResponse(userPool.map(value => value.asEditable))
    def userPool
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly]
    def getUserPool: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly
    ] = AwsError.unwrapOptionField("userPool", userPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly {
    override val userPool
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly] =
      scala
        .Option(impl.userPool())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserPoolType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse
  ): zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly =
    new Wrapper(impl)
}
