package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait MessageActionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType
}
object MessageActionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType
  ): zio.aws.cognitoidentityprovider.model.MessageActionType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.RESEND =>
      val r = RESEND
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.SUPPRESS =>
      val r = SUPPRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.MessageActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESEND
      extends zio.aws.cognitoidentityprovider.model.MessageActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.RESEND
  }
  case object SUPPRESS
      extends zio.aws.cognitoidentityprovider.model.MessageActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType.SUPPRESS
  }
}
