package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EmailSendingAccountType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType
}
object EmailSendingAccountType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType
  ): zio.aws.cognitoidentityprovider.model.EmailSendingAccountType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.COGNITO_DEFAULT =>
        val r = COGNITO_DEFAULT
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.DEVELOPER =>
        val r = DEVELOPER
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EmailSendingAccountType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.UNKNOWN_TO_SDK_VERSION
  }
  case object COGNITO_DEFAULT
      extends zio.aws.cognitoidentityprovider.model.EmailSendingAccountType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.COGNITO_DEFAULT
  }
  case object DEVELOPER
      extends zio.aws.cognitoidentityprovider.model.EmailSendingAccountType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType.DEVELOPER
  }
}
