package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class AdminDisableProviderForUserRequest(
    userPoolId: StringType,
    user: zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest = {
    import AdminDisableProviderForUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
      .builder()
      .userPoolId(StringType.unwrap(userPoolId): java.lang.String)
      .user(user.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
      .wrap(buildAwsValue())
}
object AdminDisableProviderForUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminDisableProviderForUserRequest(userPoolId, user.asEditable)
    def userPoolId: StringType
    def user: zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    def getUserPoolId: ZIO[Any, Nothing, StringType] = ZIO.succeed(userPoolId)
    def getUser: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    ] = ZIO.succeed(user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserRequest.ReadOnly {
    override val userPoolId: StringType =
      zio.aws.cognitoidentityprovider.model.primitives
        .StringType(impl.userPoolId())
    override val user
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
        .wrap(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserRequest.ReadOnly =
    new Wrapper(impl)
}
